#!/bin/bash

mountPoint=/mnt/usb
vncFile=$mountPoint/vnc.txt
translationFile=$mountPoint/override_translation.qm
backlightDevice=/sys/class/backlight/backlight/brightness

function turnOffBacklight() {
    echo 0 > $backlightDevice
}

function turnOnBacklight() {
    echo 7 > $backlightDevice
}

function mountUsb() {
    if [ -e /dev/sda1 ]; then
       mount /dev/sda1 $mountPoint
    elif [ -e /dev/sda ]; then
       mount /dev/sda $mountPoint
    fi
}

function unmountUsb() {
    if hasOverrideTranslation; then
        echo "not unmounting USB as it contains $translationFile"
        return
    fi

    umount $mountPoint

    #belt and braces approach
    if cat /proc/mounts | grep $mountPoint ; then
       echo "unmounting $mountPoint"
       umount $mountPoint
    else
       echo "no need to unmount $mountPoint!"
    fi
}

function startVnc() {
    #if file 'vnc.txt' can be found on memory stick /mnt/usb/vnc.txt then start the vnc server...
    if [ ! -f "$vncFile" ]; then
        return
    fi

    echo "found $vncFile"
    systemctl start x11vnc
}

function hasOverrideTranslation() {
    if [ -e $translationFile ]; then
        return 0
    fi

    return 1
}

function factoryReset() {
    if [ ! -e "/tmp/lantek_factory_reset" ]; then
        return
    fi
    rm -f /tmp/lantek_factory_reset
    rm -rf /opt/LanTEK/sync/*
    cd /opt/LanTEK/data/
    rm -rf *.db config.ini results fiber_inspection
    cd -
    truncate -s 0 /var/log/daemon.log
    sleep 1
    sync
    sync
    sync
    sleep 1
}

#minimise backlight brightness
#turnOffBacklight

#mount USB
mountUsb

#try launching VNC if USB contains vnc.txt
startVnc

#unmount USB if necessary
unmountUsb

#do factory reset if required
factoryReset

#max backlight brightness - will be removed when LanTEKGui takes control of the backlight.
#turnOnBacklight

#start LanEK application export
export LD_LIBRARY_PATH=/opt/LanTEK/lib
export ASAN_OPTIONS=alloc_dealloc_mismatch=0,new_delete_type_mismatch=0,memcpy-param-overlap=0,halt_on_error=0
export QTWEBENGINE_CHROMIUM_FLAGS=--no-sandbox
export QTWEBENGINEPROCESS_PATH=/opt/qt5.11.3/libexec/QtWebEngineProcess
export QT_LOGGING_CONF=/opt/LanTEK/data/qtLogging.ini
declare -i status=0;

/opt/LanTEK/bin/LanTEKGui

#LanTEKGui has exited .. play shutdown sound if clean exit..
retVal=$?

#turnOffBacklight

if [ $retVal -ne 0 ]; then
    echo "LanTEKGui returned Error "$retVal
    #lantek.service will 'restart=on-failure' 
    #provided we exit with the non-zero value here...
    exit $retVal
else
    #Arm the STM32 to allow for signal CPU_PS_Hold to power of the lantek
    #which will be written in kernel /drivers/power/reset/syscon-poweroff.c
    #at the end of the 'shutdown' command
    
    #write to STM32 CTRL2_REG - set bit 1
    i2cset -y 0 0x07 0xb c
    i2cset -y 0 0x07 0x2 c
fi
